﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class Customer

    Public idValue As Integer
    Public firstNameValue As String
    Public lastNameValue As String


    Public Property ID() As Integer
        Get
            Return idValue
        End Get
        Set(ByVal value As Integer)
            idValue = value
        End Set
    End Property

    Public Property FirstName() As String
        Get
            Return firstNameValue
        End Get
        Set(ByVal value As String)
            firstNameValue = value
        End Set
    End Property

    Public Property LastName() As String
        Get
            Return lastNameValue
        End Get
        Set(ByVal value As String)
            lastNameValue = value
        End Set
    End Property

    Public Shared Function EditCustomer(ByVal Id As Integer) As Customer
        ' 假定在数据库中查找客户，但是
        ' 找不到，因此我们以一种对方无法忽视
        ' 的方式通知调用方。

        Dim message As String
        message = String.Format("The customer you requested by Id {0} could not be found.", Id)

        ' 创建异常。
        Dim exp As New CustomerNotFoundException(message)
        ' 向调用方引发该异常。
        Throw exp

    End Function

    Public Shared Sub DeleteCustomer(ByVal Id As Integer)
        ' 假定在数据库中找到了客户，但是
        ' 发现无法将其删除，可能是由于
        ' 安全的缘故。

        Dim c As New Customer()
        With c
            .Id = Id
            .FirstName = "Mary"
            .LastName = "Baker"
        End With

        ' 如果不具有相应的权限，则此操作可能会失败。
        Dim user As String
        Try
            user = System.Environment.UserDomainName & "\" & System.Environment.UserName
        Catch pexp As Exception
            user = "Unavailable"
        End Try

        Dim message As String
        message = String.Format("The customer you requested {0} {1} could not be deleted. Your account {2} does not have permission.", c.FirstName, c.LastName, user)

        Dim exp As New CustomerNotDeletedException(message, c, user)
        exp.LogError()

        Throw exp

    End Sub
End Class








